/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FillDatabaseTaskExecutor;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.ProgressWindowTask;
import java.awt.Component;
import java.util.Map;

class FillDatabaseTask
implements ProgressWindowTask<Integer> {
    private int totalFound;
    private boolean exceptionThrown = false;
    private final FillDatabaseTaskExecutor taskExecutor;
    private final Component parentWindow;
    private final Map<String, String> messages;
    private final boolean rightToLeft;

    FillDatabaseTask(FillDatabaseTaskExecutor taskExecutor, Component parentWindow, Map<String, String> messages, boolean rightToLeft) {
        this.taskExecutor = taskExecutor;
        this.parentWindow = parentWindow;
        this.messages = messages;
        this.rightToLeft = rightToLeft;
    }

    @Override
    public void execute() {
        try {
            this.totalFound = this.taskExecutor.execute();
        }
        catch (LauncherException le) {
            this.totalFound = 0;
            this.exceptionThrown = true;
            MessageBoxUtil.showErrorMessageBox(this.parentWindow, le, this.messages, this.rightToLeft);
        }
    }

    @Override
    public Integer getResult() {
        return this.totalFound;
    }

    @Override
    public void interrupt() {
        this.taskExecutor.interrupt();
    }

    @Override
    public boolean isError() {
        return this.exceptionThrown;
    }
}

